<?php

/**
* JoomlaWatch - A real-time ajax joomla monitor and live stats
* @version 1.2.0
* @package JoomlaWatch
* @license http://www.gnu.org/licenses/gpl-3.0.txt 	GNU General Public License v3
* @copyright (C) 2007 by Matej Koval - All rights reserved! 
* @website http://www.codegravity.com
**/

class JoomlaWatch {

	function checkPermissions() {
		global $database;

		$rand = JoomlaWatch :: getRand();
		if ($rand == $_GET['rand']) return true;
		else return false;
		
	}


	function getRand() {
		global $database;
		$query = "select value from #__joomlawatch_helper where name = 'rand' order by id desc limit 1";
		$database->setQuery($query);
		$database->query();
		$rows = $database->loadObjectList();
		$row = @ $rows[0];

		$rand = @ $row->value;

		return $rand;

	}


	function getLastVisitId() {
		global $database;
		$query = "select id from #__joomlawatch_uri order by id desc limit 1";
		$database->setQuery($query);
		$rows = $database->loadObjectList();
		$row = @ $rows[0];

		$last = @ $row->id;

		return $last;
	}

	function deleteOldVisits() {
		global $database;

		$query = "select id as maxid from #__joomlawatch where browser is not NULL order by id desc limit 1";
		$database->setQuery($query);
		$rows = @ $database->loadObjectList();
		$row = @ $rows[0];
		$maxidvisitors = @ $row->maxid - JOOMLAWATCH_MAXID_VISITORS;

		$query = "delete from #__joomlawatch where (browser is not NULL and id < $maxidvisitors) ";
		$database->setQuery($query);
		$database->query();

		$query = "delete from #__joomlawatch_uri where fk < '$maxidvisitors' ";
		$database->setQuery($query);
		$database->query();

		$maxidbots = @ $row->maxid - JOOMLAWATCH_MAXID_BOTS;

		$query = "select id from #__joomlawatch where (id < $maxidbots and browser is NULL) order by id desc";
		$database->setQuery($query);
		$rows = @ $database->loadObjectList();

		foreach ($rows as $row) {

			$query = "delete from #__joomlawatch where id = '$row->id' ";
			$database->setQuery($query);
			$database->query();

			$query = "delete from #__joomlawatch_uri where fk = '$row->id' ";
			$database->setQuery($query);
			$database->query();

		}

		if (JOOMLAWATCH_STATS_KEEP_DAYS != 0) {	// 0 = infinite
			$today = time() / 3600 / 24;
			$daysToKeep = $today -JOOMLAWATCH_STATS_KEEP_DAYS;

			$query = "delete from #__joomlawatch_info where date < '$daysToKeep' ";
			$database->setQuery($query);
			$database->query();
		}

	}

	function getURI() {
		$redirURI = @ $_SERVER['REDIRECT_URL'];
		$uri = @ $_SERVER['REQUEST_URI'];

		if (@ $redirURI)
			$uri = $redirURI;

		return $uri;
	}

	function insertVisit() {
		global $mainframe, $database, $_SERVER;

		if (rand() % (JOOMLAWATCH_MAXID_BOTS / 2) == 0) {
			JoomlaWatch :: deleteOldVisits();
		}

		$uri = JoomlaWatch :: getURI();

		$ip = @ $_SERVER['REMOTE_ADDR'];
		$time = time();

		$query = "select id from #__joomlawatch where ip = '$ip' limit 1";
		$database->setQuery($query);
		$rows = @ $database->loadObjectList();
		$row = @ $rows[0];
		$id = @ $row->id;

		$title = $mainframe->getPageTitle();
		if (!@ $id) {

			$query = "insert into #__joomlawatch (id, ip, country, browser) values ('', '$ip',  NULL, NULL) ";
			$database->setQuery($query);
			$database->query();

			$query = "select id from #__joomlawatch where ip = '$ip' limit 1";
			$database->setQuery($query);
			$rows = @ $database->loadObjectList();
			$row = @ $rows[0];
			$id = @ $row->id;

			$query = "insert into #__joomlawatch_uri (id, fk, timestamp, uri, title) values ('', '$id', '$time', '$uri', '$title') ";
			$database->setQuery($query);
			$database->query();
		} else {

			$query = "insert into #__joomlawatch_uri (id, fk, timestamp, uri, title) values ('', '$id', '$time', '$uri', '$title') ";
			$database->setQuery($query);
			$database->query();

		}

		JoomlaWatch :: increaseKeyValueInGroup("hits", "hits");

	}

	function updateVisitByBrowser($uri) {
		global $database, $mainframe;

		$ip = $_SERVER['REMOTE_ADDR'];
		$userAgent = @ $_SERVER['HTTP_USER_AGENT'];

		JoomlaWatch :: updateBrowserStats($ip, $userAgent);

		$query = "select #__joomlawatch_uri.uri from #__joomlawatch left join #__joomlawatch_uri on #__joomlawatch.id = #__joomlawatch_uri.fk  where (#__joomlawatch.ip = '$ip' and #__joomlawatch.browser is not null) order by #__joomlawatch_uri.timestamp desc limit 1";
		$database->setQuery($query);
		$rows = @ $database->loadObjectList();
		$row = @ $rows[0];
		$uri = @ $row->uri;

		JoomlaWatch :: increaseKeyValueInGroup("uri", $uri);
		JoomlaWatch :: increaseKeyValueInGroup("loads", "loads");

	}

	function increaseKeyValueInGroup($name, $key) {
		global $database;

		if (!@ $key)
			return;

		$date = floor(time() / 3600 / 24);

		$query = "select id,value from #__joomlawatch_info where (`group` = '$name' and name = '$key' and date = '$date') ";
		$database->setQuery($query);
		$rows = @ $database->loadObjectList();
		$row = @ $rows[0];
		$count = @ $row->value;

		if (@ $count) {
			$count++;
			$query = "update #__joomlawatch_info set value = '$count' where (`group` = '$name' and name = '$key' and date = '$date') ";
			$database->setQuery($query);
			$database->query();
		} else {
			$query = "insert into #__joomlawatch_info (id, `group`, date, name, value) values ('', '$name', '$date', '$key', 1)";
			$database->setQuery($query);
			$database->query();

		}
	}

	function getKeyValueInGroupByDate($name, $key, $date) {
		global $database;

		if (!@ $key)
			return;

		$query = "select id,value from #__joomlawatch_info where (`group` = '$name' and name = '$key' and date = '$date') ";
		$database->setQuery($query);
		$rows = @ $database->loadObjectList();
		$row = @ $rows[0];
		$value = @ $row->value;

		return $value;
	}

	function getCountByKeyAndDate($key, $date) {
		global $database;

		$query = "select sum(value) as value from #__joomlawatch_info where (`group` = '$key' and date = '$date') order by id desc limit 1";
		$database->setQuery($query);
		$rows = @ $database->loadObjectList();
		$row = @ $rows[0];
		$count = @ $row->value;

		return @ $count;
	}

	function getTotalCountByKey($key) {
		global $database;

		$query = " SELECT sum( value ) AS value FROM #__joomlawatch_info WHERE `group` = '$key' LIMIT 1 ";
		$database->setQuery($query);
		//echo ($database->getQuery());
		$rows = @ $database->loadObjectList();
		$row = @ $rows[0];
		$count = @ $row->value;

		return @ $count;
	}

	function updateHelperCountByKey($key, $value) {
		global $database;

		$count = JoomlaWatch :: getCountByKey($key);

		if (@ $count) {
			$query = "update #__joomlawatch_helper set value = '$value' where (name = '$key' and date = '$date')";
			$database->setQuery($query);
			$database->query();
		} else {
			$query = "insert into #__joomlawatch_helper values ('', '$key', '$value')";
			$database->setQuery($query);
			$database->query();
		}
	}

	function updateBrowserStats($ip, $userAgent) {
		global $database;

		$query = "select id,browser from #__joomlawatch where ip = '$ip' order by id asc limit 1";
		$database->setQuery($query);
		$rows = @ $database->loadObjectList();
		$row = @ $rows[0];
		if (@ $row->browser == '')
			$firstTime = true;

		$country = JoomlaWatch :: countryByIp($ip);

		$query = "select browser,country from #__joomlawatch where ip = '$ip' order by browser desc limit 1";
		$database->setQuery($query);
		$rows = @ $database->loadObjectList();
		$row = @ $rows[0];

		//check if first time visit

		if (@ !$row->browser) {
			JoomlaWatch :: increaseKeyValueInGroup("unique", "unique");

			$query = "update #__joomlawatch set browser = '$userAgent' where ip = '$ip'";
			$database->setQuery($query);
			$database->query();

			$browser = JoomlaWatch :: identifyBrowser(@ $userAgent);
			JoomlaWatch :: increaseKeyValueInGroup("browser", $browser);

			$os = JoomlaWatch :: identifyOs(@ $userAgent);
			JoomlaWatch :: increaseKeyValueInGroup("os", $os);

			JoomlaWatch :: increaseKeyValueInGroup("country", $country);

		}

	}

	function countryByIp($ip) {
		global $database;

		if ($ip == '127.0.0.1')
			return;

		$query3 = "select ip, country from #__joomlawatch where (ip = '$ip' and country is not NULL) limit 1";
		$database->setQuery($query3);
		$database->query();
		$rows3 = $database->loadObjectList();
		$row3 = @ $rows3[0];

		if (@ !$row3->country) {

			$iplook = new ip2country($ip);
			$iplook->UseDB = true;
			$iplook->db_tablename = "#__joomlawatch_ip2c";

			if (($iplook->LookUp())) {
				$country = strtolower($iplook->Prefix1);
				$query3 = "update #__joomlawatch set country = '$country' where ip = '$ip'";
				$database->setQuery($query3);
				$database->query();
			}

		} else {
			$country = $row3->country;
		}

		return @ $country;
	}

	function truncate($str, $len = JOOMLAWATCH_TRUNCATE_VISITS) {
		if (strlen($str) < $len)
			return $str;
		else
			return substr($str, 0, $len) . "...";
	}

	function identifyOs($userAgent) {
		global $mosConfig_live_site;
		if (stristr($userAgent, "Mac"))
			$os = "Mac";
		else
			if (stristr($userAgent, "Linux"))
				$os = "Linux";
			else
				if (stristr($userAgent, "Windows 95"))
					$os = "Windows98";
				else
					if (stristr($userAgent, "Windows 98"))
						$os = "Windows98";
					else
						if (stristr($userAgent, "Windows ME"))
							$os = "Windows98";
						else
							if (stristr($userAgent, "Windows NT 4.0"))
								$os = "WindowsNT";
							else
								if (stristr($userAgent, "Windows NT 6.0"))
									$os = "WindowsVista";
								else
									if (stristr($userAgent, "Windows NT 5.1"))
										$os = "WindowsXP";
									else
										if (stristr($userAgent, "Windows"))
											$os = "Windows";

		return @ $os;
	}

	function identifyBrowser($userAgent) {
		global $mosConfig_live_site;

		if (stristr($userAgent, "Safari"))
			$browser = "Safari";
		else
			if (stristr($userAgent, "MSIE"))
				$browser = "Explorer";
			else
				if (stristr($userAgent, "Firefox"))
					$browser = "Firefox";
				else
					if (stristr($userAgent, "Opera"))
						$browser = "Opera";
					else
						if (stristr($userAgent, "Mozilla"))
							$browser = "Mozilla";

		return @ $browser;
	}

	function getBrowserByIp($ip) {
		global $database;

		if ($ip == '127.0.0.1')
			return;

		$query = "select browser from #__joomlawatch where (ip = '$ip' and browser is not NULL) order by browser desc limit 1";
		$database->setQuery($query);

		$database->query();
		$rows = $database->loadObjectList();
		$row = @ $rows[0];

		return @ $row->browser;
	}

}
?>