<?php

/**
* JoomlaWatch - A real-time ajax joomla monitor and live stats
* @version 1.2.0
* @package JoomlaWatch
* @license http://www.gnu.org/licenses/gpl-3.0.txt 	GNU General Public License v3
* @copyright (C) 2007 by Matej Koval - All rights reserved! 
* @website http://www.codegravity.com
**/

class JoomlaWatchHTML {

	function renderIntValuesByName($name, $date = "", $expanded = false, $limit = 5) {
		global $database, $mosConfig_live_site;

		if ($date == "")
			$date = floor(time() / 3600 / 24);

		if (@ $expanded == true)
			$query = "select name, value from #__joomlawatch_info where (`group` = '$name' and `date` = '$date') order by value desc limit 20";
		else
			$query = "select name, value from #__joomlawatch_info where (`group` = '$name' and `date` = '$date') order by value desc limit $limit";

		$database->setQuery($query);
		$rows = @ $database->loadObjectList();

		$i = 0xFF;

		$output = "";
		foreach ($rows as $row) {

			$count = JoomlaWatch :: getCountByKeyAndDate($name, $date);
			if ($count)
				$percent = floor(($row->value / $count) * 1000) / 10;
			else
				$percent = 0;

			if (@ $name == 'uri' || @ $name == 'uri_total') {
				$nameTruncated = JoomlaWatch :: truncate($row->name, JOOMLAWATCH_TRUNCATE_STATS);
				$row->name = "<a href='$mosConfig_live_site$row->name' title='$row->name'>$nameTruncated</a>";
			} else
				if (@ $row->name && ($name == 'browser' || $name == 'os' || $name == 'browser_total' || $name == 'os_total'))
					$icon = "<img src='$mosConfig_live_site/components/com_joomlawatch/icons/" . strtolower($row->name) . ".gif' />";
				else
					if ($name == 'country' || $name == 'country_total') {
						if ($row->name)
							$icon = "<img src='$mosConfig_live_site/components/com_joomlawatch/flags/" . strtolower($row->name) . ".png' />";

					}
			$progressBarIcon = "$mosConfig_live_site/components/com_joomlawatch/icons/progress_bar.gif";

			if (@ $row->name)
				$output .= "<tr><td>" . @ $icon . "&nbsp;" . $row->name . "</td><td align='right'>" . $row->value . "</td><td> <table><tr><td><img src='$progressBarIcon' width='$percent' height='10'/></td><td>$percent%</td></tr></table></td></tr>";
		}
		if (@ $count)
			$output .= "<tr><td colspan='5'><b>Total:</b> " . @ $count . " </td></tr>";

		return $output;
	}

	function renderTotalIntValuesByName($name, $expanded = false, $limit = 5) {
		global $database, $mosConfig_live_site;

		$date = floor(time() / 3600 / 24);

		if (@ $expanded == true)
			$query = "select name, sum(value) as value from jos_joomlawatch_info where (`group` = '$name') group by name order by value desc";
		else
			$query = "select name, sum(value) as value from jos_joomlawatch_info where (`group` = '$name') group by name order by value desc limit $limit";

		$database->setQuery($query);
		$rows = @ $database->loadObjectList();

		$i = 0xFF;

		$output = "";
		$count = JoomlaWatch :: getTotalCountByKey($name);

		foreach ($rows as $row) {
			$i -= 3;
			$color = sprintf("%x", $i) . sprintf("%x", $i) . sprintf("%x", $i);

			if ($count)
				$percent = floor(($row->value / $count) * 1000) / 10;
			else
				$percent = 0;

			if (@ $name == 'uri' || @ $name == 'uri_total') {
				$nameTruncated = JoomlaWatch :: truncate($row->name, JOOMLAWATCH_TRUNCATE_STATS);
				$row->name = "<a href='$mosConfig_live_site$row->name' title='$row->name'>$nameTruncated</a>";
			} else
				if (@ $row->name && ($name == 'browser' || $name == 'os' || $name == 'browser_total' || $name == 'os_total'))
					$icon = "<img src='$mosConfig_live_site/components/com_joomlawatch/icons/" . strtolower($row->name) . ".gif' />";
				else
					if ($name == 'country' || $name == 'country_total') {
						if ($row->name)
							$icon = "<img src='$mosConfig_live_site/components/com_joomlawatch/flags/" . strtolower($row->name) . ".png' />";

					}

			$progressBarIcon = "$mosConfig_live_site/components/com_joomlawatch/icons/progress_bar.gif";

			$color = "ffffff";
			if (@ $row->name)
				$output .= "<tr><td style='background-color: #$color;'>" . @ $icon . "&nbsp;" . $row->name . "</td><td style='background-color: #$color;' align='right'>" . $row->value . "</td><td style='background-color: #$color;'> <table><tr><td><img src='$progressBarIcon' width='$percent' height='10'/></td><td>$percent%</td></tr></table></td></tr>";
		}
		if (@ $count)
			$output .= "<tr><td colspan='5'><b>Total:</b> " . @ $count . " </td></tr>";

		return $output;
	}

	function renderVisitsGraph($week = 0) {
		global $mosConfig_live_site;
		$output = "";

		$today = date("d.m.Y", time());

		$dateExploded = explode('.', $today);

		$dayOfWeek = date("w", time());

		$timestamp = ($week + $dayOfWeek) * 24 * 3600 * 7;

	//	$output .= $dayOfWeek;

		$startTimestamp = $timestamp - (24 * 3600 * $dayOfWeek -1);

		$i = 0xFF;

	//	$startTimestamp = $week * 24 * 3600 * 7 - (24 * 3600 * $dayOfWeek -1);
	
//		$output .= $dayOfWeek;

		for ($sec = 24 * 3600 * (($week *7)-3) ; $sec < 24 * 3600 * (($week*7) + 4); $sec += 24 * 3600) {
			$i -= 3;
			$color = sprintf("%x", $i) . sprintf("%x", $i) . sprintf("%x", $i);

			if ($i%2 ==0) $color = "#f5f5f5"; else $color = "#fafafa";

			$percent = 0;
			$count = 0;
			$date = floor($sec / 3600 / 24);

			$stats['unique'] = JoomlaWatch :: getKeyValueInGroupByDate("unique", "unique", $date);
			$stats['loads'] = JoomlaWatch :: getKeyValueInGroupByDate("loads", "loads", $date);
			$stats['hits'] = JoomlaWatch :: getKeyValueInGroupByDate("hits", "hits", $date);

			foreach ($stats as $key => $value) {

				$count = $stats['loads'];
				if ($count)
					$percent = floor(($value / $count) * 100);

				$progressBarIcon = "$mosConfig_live_site/components/com_joomlawatch/icons/progress_bar_$key.gif";

				$output .= "<tr><td style='background-color: $color;'>";
				$dow = date("D", $sec);
				if (@ !$once[$dow]) {
					$output .= substr(date("d.m.Y", $sec), 0, 6) . "&nbsp;" . $dow;
					$once[$dow] = 1;
				}
				$output .= "</td>";

				if ($key == "unique")
					$fontColor = "#0000FF";
				else
					if ($key == "loads")
						$fontColor = "#00C000";
					else
						if ($key == "hits")
							$fontColor = "#aaaaaa";
						else
							$fontColor = "black";
				$percentWidth = $percent;
				if ($key == "hits")
					$percentWidth = 50; // smaller hits bar hack
				if (@ $value) {
					if ($key == "hits") $output .= "<td align='right' style='color:$fontColor; background-color: $color;'>" . $value . "</td><td style='background-color: $color;'> <table cellpadding='0' cellspacing='0' ><tr><td style='background-color: $color;'></td><td style='color:$fontColor; background-color: $color;'>&nbsp;</td></tr></table></td>"; 
					else
					if ($key == "loads") $output .= "<td align='right' style='color:$fontColor; background-color: $color;'>" . $value . "</td><td style='background-color: $color;'> <table cellpadding='0' cellspacing='0' ><tr><td style='background-color: $color;'><img src='$progressBarIcon' width='$percentWidth' height='10' /></td><td style='color:$fontColor; background-color: $color;'></td></tr></table></td>";
					else
					$output .= "<td align='right' style='color:$fontColor; background-color: $color;'>" . $value . "</td><td style='background-color: $color;'> <table cellpadding='0' cellspacing='0' ><tr><td style='background-color: $color;'><img src='$progressBarIcon' width='$percentWidth' height='10' /></td><td style='color:$fontColor; background-color: $color;'>&nbsp;$percent%</td></tr></table></td>";
				}
					else $output .= "<td align='right' style='background-color: $color;'></td><td align='right' style='background-color: $color;'></td>";

				$output .= "</tr>";

			}

		}
				$output .= "<tr><td colspan='3' align='right'>* <span style='color:#0000FF;'>unique</span>, <span style='color:#00C000;'>loads</span>, <span style='color:#aaaaaa;'>hits</span></td></tr>";

		return $output;
	}

	function renderTable($rows, $bots = false) {
		global $database, $mosConfig_live_site;

		$output = "";
		$i = 0xFF;
		foreach ($rows as $row) {
			if ($i > 0x00)
				$i -= 2;
			else
				$i = 0xFF;

			$query2 = "SELECT * FROM #__joomlawatch LEFT JOIN #__joomlawatch_uri ON #__joomlawatch.id = #__joomlawatch_uri.fk where ip = '$row->ip' ORDER BY #__joomlawatch_uri.timestamp desc";
			$database->setQuery($query2);
			$rows2 = $database->loadObjectList();
			$row2 = $rows2[0];

			$color = sprintf("%x", $i) . sprintf("%x", $i) . sprintf("%x", $i);

			if ($bots == true)
				$color = "ffffff";

			$country = $row2->country;

			if (!$country)
				$country = JoomlaWatch :: countryByIp($row->ip);

			if (@ $country) {
				$flag = "<img src='$mosConfig_live_site/components/com_joomlawatch/flags/$country.png'/>";
				$countryUpper = strtoupper($country);
			}

			$userAgent = JoomlaWatch :: getBrowserByIp($row->ip);

			$browser = "";
			$os = "";
			$browserIcon = "";
			$osIcon = "";

			if (@ $userAgent) {
				$browser = JoomlaWatch :: identifyBrowser(@ $userAgent);
				if (@ $browser)
					$browserIcon = "$mosConfig_live_site/components/com_joomlawatch/icons/" . strtolower($browser) . ".gif";

				if (@ $browserIcon)
					$browser = "<img src='$browserIcon' alt='$userAgent' title='$userAgent' />";

				$os = JoomlaWatch :: identifyOs(@ $userAgent);

				if (@ $os)
					$osIcon = "$mosConfig_live_site/components/com_joomlawatch/icons/" . strtolower($os) . ".gif";

				if (@ $osIcon)
					$os = "<img src='$osIcon' alt='$userAgent' title='$userAgent'/>";
			}

			if ($bots == true && $osIcon)
				continue; // bot icon fix
			if ($bots == true) {
				$osIcon = "$mosConfig_live_site/components/com_joomlawatch/icons/blank.gif";
				$browserIcon = "$mosConfig_live_site/components/com_joomlawatch/icons/blank.gif";
				$browser = "<img src='$browserIcon' alt='$userAgent' title='$userAgent' />";
				$os = "<img src='$osIcon' alt='$userAgent' title='$userAgent'/>";
			}

			$output .= ("<tr><td valign='top' align='left' style='background-color: #$color'>" . @ $row->id . "</td> 
																								<td valign='top' align='left' style='background-color: #$color; color: #999999;'>" . @ $countryUpper . "</td>
																								<td valign='top' align='left'  style='background-color: #$color;' title='" . @ $row2->browser . "'>" . @ $flag . "&nbsp;$row->ip</td>
																								<td valign='top' align='left' style='background-color: #$color;'>" . @ $browser . "</td>
																								<td valign='top' align='left' style='background-color: #$color;'>" . @ $os . "</td>
																								<td valign='top' align='left' style='background-color: #$color;'>");
			foreach ($rows2 as $row2) {

				$row2->timestamp = date("H:i:s", $row2->timestamp);
				$uriTruncated = JoomlaWatch :: truncate($row2->uri);
				$row2->title = JoomlaWatch :: truncate($row2->title);

				$output .= ("<div id='id$row2->id' style='background-color: #$color'>$row2->timestamp <a href='$row2->uri' target='_blank'>$row2->title</a> $uriTruncated</div>");

			}

			$output .= ("</td></tr>");
		}

		return $output;
	}

	function renderExpand($element) {
		global $mosConfig_live_site;
		if (@ $_GET[$element] == "false" || !@ $_GET[$element])
			$operation = "expand";
		else
			$operation = "collapse";

		$output = "<a name='$element'></a><a href=\"javascript:expand('$element')\" id='$element'><img src='$mosConfig_live_site/components/com_joomlawatch/icons/$operation.gif' border='0' alt='$operation'/>$operation $element</a>";

		return $output;
	}

	function renderVisitors() {
		global $database;

		$query = "select ip from #__joomlawatch where (browser is not NULL and browser != '') order by id desc";
		$database->setQuery($query);
		$rows = $database->loadObjectList();

		$output = JoomlaWatchHTML :: renderTable($rows);

		return $output;
	}

	function renderBots() {
		global $database;
		$query = "select ip from #__joomlawatch where (browser is NULL) order by id desc";
		$database->setQuery($query);
		$rows = $database->loadObjectList();

		$output = JoomlaWatchHTML :: renderTable($rows, true);

		return $output;
	}

	function getDateByDay($day) {

		$date = date("d.m.Y", $day * 3600 * 24);
		$output = $date;
		if ($date == date("d.m.Y", time()))
			$output .= " (today)";

		return $output;
	}

	function renderSwitched($element, $text, $clickable = true) {
		$output = "";
		if ($clickable) {
			$output .= "<a href=\"javascript:setStatsType('$element');\" id='$element'>$text</a>";
		} else
			$output .= "$text</a>";

		return $output;
	}

	function renderTabClass($boolean) {
		if ($boolean == true)
			return "tab_active";
		else
			return "tab_inactive";
	}

}
?>